<?php 
    $queryString = $_SERVER['QUERY_STRING'];
    parse_str($queryString, $queryParams);
    $businessid = isset($queryParams['business']) ? $queryParams['business'] : null;

    include("../shared/common.php");
    
    if (!$businessid) {
        echo "<div style='text-align: center; font-family: Arial, sans-serif; padding: 20px;'>
                <h1>Business Not Found</h1>
                <p>Please provide a valid business ID in the URL.</p>
              </div>";
        exit;
    }
    
    $query = "SELECT * FROM business WHERE id=$businessid";
	$result = $db->query($query);
	$selectrow = mysqli_fetch_array($result);

    $name = $selectrow['name'];
    $logo = $selectrow['logo'];
    $background = $selectrow['background'];
    $menu = $selectrow['menu'];
    $menu_link = $selectrow['menu_link'];
    $color = $selectrow['color'];
?>

<html>
    <head>
	<link rel="shortcut icon" href=<?php echo "../shared/logos/".$logo; ?>>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width,initial-scale=1">
        <meta name="description" content="WeReview System" />
        <link rel="preconnect" href="https://fonts.gstatic.com" />
        <title><?php echo $name;?></title>
        <link href="assets/css/styles.css" rel="stylesheet" />
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap" rel="stylesheet" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    </head>
    
    <body>

        <div class="container" style="background-image: url('<?php echo "../shared/backgrounds/".$background;?>');">
            <div class="background"></div>
            <div class="content top">
                <img class="logo" src=<?php echo "../shared/logos/".$logo;?> alt="Logo">
                <div class="form">
                    <h2>Welcome to <?php echo $name?>!</h2>
                    <div class="buttons">
                        <button class="flex button" type="button" onclick="redirect('auth?business=<?php echo $businessid; ?>')" style="background-color: <?php echo $color ?>;">
                            <div class="flex-item"><img src="../shared/gif/star.gif" height="30px" /></div>
                            <div class="flex-item main-column">Review</div>
                            <div class="flex-item"></div>
                        </button>
                        <?php
                            if($menu_link){
                        ?>
                        <button class="flex button" type="button" onclick="goToLink('<?php echo $menu_link; ?>')" style="background-color:<?php echo $color; ?>">
                            <div class="flex-item"><img src="../shared/gif/cutlery.gif" height="30px" /></div>
                            <div class="flex-item main-column">Menu</div>
                            <div class="flex-item"></div>
                        </button>
                        <?php
                            }
                        ?>
                        <?php
                            if($menu && !$menu_link){
                                $filePath = '../shared/menus/'.$menu;
                        ?>
                        <button class="flex button" type="button" onclick="openPDF('<?php echo $filePath; ?>')" style="background-color:<?php echo $color; ?>">
                            <div class="flex-item"><img src="../shared/gif/cutlery.gif" height="30px" /></div>
                            <div class="flex-item main-column">Menu</div>
                            <div class="flex-item"></div>
                        </button>
                        <?php
                            }
                        ?>
                    </div>
                </div>
            </div>
            <img class="powered" src="../shared/logos/powered.png" alt="Powered">
        </div>

        <script>
            function openPDF(filePath) {
                window.open(filePath, '_blank');
            }
            function goToLink(linkURL) {
                window.open(linkURL, "_blank");
            }
            function redirect(linkURL) {
                window.location = linkURL;
            }
        </script>
    </body>
</html>