$(document).ready(function() {
    $.ajax({
        url: "./assets/api/businesses.php",
        type: 'POST',
        data: {mode: 'GET_businesses', active:1},
        success: function (data) {
            let transformedData = [];
            for (let i = 0; i < data.length; i++) {
                let row = data[i];
                let logo = '../../shared/logos/' + row['logo'];
                let transformedRow = {
                    'id': row['id'],
                    'name': row['name'],
                    'country': row['country'],
                    'city': row['city'],
                    'logo': logo,
                    'email': row['email'],
                    'phone': row['phone'],
                    'mobile': row['mobile'],
                    'active': row['active'],
                    'c_date': row['c_date']
                };
                transformedData.push(transformedRow);
            }

            $('#datatable').DataTable({
                scrollX: true,
                data: transformedData,
                columns: [
                    { title: '#', data: 'id' },
                    { title: 'Name', data: 'name' },
                    { title: 'Country', data: 'country' },
                    { title: 'City', data: 'city' },
                    { 
                        title: 'Logo', 
                        data: null,
                        render: function (data, type, row) {
                            return `<img src=${data.logo} style="width:50px;"/>`;
                        }
                    },
                    { title: 'Email', data: 'email' },
                    { title: 'Phone', data: 'phone' },
                    { title: 'Mobile', data: 'mobile' },
                    { title: 'Creation Date', data: 'c_date' },
                    {
                        title: 'Actions',
                        data: null,
                        render: function (data, type, row) {
                            let html = `<div class="d-flex align-items-center gap-3">
                            <a href="edit-business?id=${data.id}"><i class="fa fa-pencil fa-lg" aria-hidden="true"></i></a>`;
                            if(data.active == 1)
                                html += `<a href="deactivate-business?id=${data.id}"><i class="fa fa-toggle-on fa-lg" aria-hidden="true"></i></a>`;
                            else
                                html += `<a href="activate-business?id=${data.id}"><i class="fa fa-toggle-off fa-lg" aria-hidden="true"></i></a>`;
                            html += `</div>`;
                            return html;
                        }
                    }
                ]
            });
        }
    });
});

$(document).on("click","#active-btn",function(e){
    e.preventDefault();
    $("#inactive-btn").removeClass("active");
    $("#active-btn").addClass("active");
    loadingBusinesses(1);
});

$(document).on("click","#inactive-btn",function(e){
    e.preventDefault();
    $("#active-btn").removeClass("active");
    $("#inactive-btn").addClass("active");
    loadingBusinesses(0);
});

function loadingBusinesses(active) {
    $.ajax({
        url: "./assets/api/businesses.php",
        type: 'POST',
        data: {mode: 'GET_businesses', active},
        success: function (data) {
            let transformedData = [];
            for (let i = 0; i < data.length; i++) {
                let row = data[i];
                let logo = '../../shared/logos/' + row['logo'];
                let transformedRow = {
                    'id': row['id'],
                    'name': row['name'],
                    'country': row['country'],
                    'city': row['city'],
                    'logo': logo,
                    'email': row['email'],
                    'phone': row['phone'],
                    'mobile': row['mobile'],
                    'active': row['active'],
                    'c_date': row['c_date']
                };
                transformedData.push(transformedRow);
            }

            let dataTable = $('#datatable').DataTable();
            dataTable.clear().rows.add(transformedData).draw();
        }
    });
}