$(document).on("click","#update",function(e){
    e.preventDefault();

    let notificationid = $("#notificationid").val();

    let active = 0;
    if($("#active").prop("checked") === true){ active = 1; }
    
    let host = $("#host").val();
    if(!host && active == 1){
        $("#lblhost").addClass("text-danger");
        $("#host").addClass("is-invalid");
        $("#feedbackhost").text("This field is required!");
        $('html, body').animate({
            scrollTop: ($('#lblhost').offset().top - 60)
        }, 500);
    } else{
        $("#lblhost").removeClass("text-danger");
        $("#host").removeClass("is-invalid");
        $("#feedbackhost").text("");
    }

    let email = $("#email").val();
    let validEmail = false;
    if(!email && active == 1){
        $("#lblemail").addClass("text-danger");
        $("#email").addClass("is-invalid");
        $("#feedbackemail").text("This field is required!");
        if(host){
            $('html, body').animate({
                scrollTop: ($('#lblemail').offset().top - 60)
            }, 500);
        }
    } else{
        if(isEmail(email)){
            $("#lblemail").removeClass("text-danger");
            $("#email").removeClass("is-invalid");
            $("#feedbackemail").text("");
            validEmail = true;
        }
        else {
            $("#lblemail").addClass("text-danger");
            $("#email").addClass("is-invalid");
            $("#feedbackemail").text("This is not a valid email!");
            if(email){
                $('html, body').animate({
                    scrollTop: ($('#lblemail').offset().top - 60)
                }, 500);
            }
        } 
    }

    let password = $("#password").val();
    if(!password && active == 1){
        $("#lblpassword").addClass("text-danger");
        $("#password").addClass("is-invalid");
        $("#feedbackpassword").text("This field is required!");
        if(host && validEmail){
            $('html, body').animate({
                scrollTop: ($('#lblpassword').offset().top - 60)
            }, 500);
        }
    } else{
        $("#lblpassword").removeClass("text-danger");
        $("#password").removeClass("is-invalid");
        $("#feedbackpassword").text("");
    }
    
    if((active && host && validEmail && password) || (!active)){
        $.ajax({
            url: "./assets/api/notifications.php",
            type: 'POST',
            data: {mode: 'UPDATE_notification', notificationid, active, host, email, password},
            success: function (response) {
                if(response === 'DONE')
                    alert("Updated successfully!");
                else 
                    alert("Failed!");
            }
        });
    }
});

function isEmail(email){
    let regex = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return regex.test(email);
}