<?php
	class MySQLDatabase {
		private $host;
		private $username;
		private $password;
		private $database;
		private $connection;
	
		public function __construct($host, $username, $password, $database) {
			$this->host = $host;
			$this->username = $username;
			$this->password = $password;
			$this->database = $database;
		}
	
		public function connect() {
			$this->connection = mysqli_connect($this->host, $this->username, $this->password, $this->database);
	
			if (!$this->connection) {
				die("Database connection failed: " . mysqli_connect_error());
			}

			mysqli_set_charset($this->connection, 'utf8');

			return $this->connection;
		}
	
		public function disconnect() {
			mysqli_close($this->connection);
		}
	
		public function query($sql) {
			$result = mysqli_query($this->connection, $sql);
	
			if (!$result) {
				die("Query execution failed: " . mysqli_error($this->connection));
			}
	
			return $result;
		}

		public function insertAndGetLastId($query) {
			$result = mysqli_query($this->connection, $query);
			
			if ($result) {
				// Retrieve the last inserted ID
				$lastInsertedId = mysqli_insert_id($this->connection);
				return $lastInsertedId;
			} else {
				// Handle the case where the INSERT query failed
				echo "Error: " . mysqli_error($this->connection);
				return null;
			}
		}
	
		public function fetchArray($result) {
			return mysqli_fetch_array($result);
		}

		public function fetchAssoc($result) {
			return mysqli_fetch_assoc($result);
		}
	
		public function numRows($result) {
			return mysqli_num_rows($result);
		}
	
		public function escapeString($string) {
			return mysqli_real_escape_string($this->connection, $string);
		}
	}
?>